Ext.data.JsonP.sol_common_ConfigCache({"tagname":"class","name":"sol.common.ConfigCache","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.Config.js","href":"lib_sol.common.Config.html#sol-common-ConfigCache"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":["sol.common.Cache"],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"cache","tagname":"property","owner":"sol.common.ConfigCache","id":"property-cache","meta":{"private":true}},{"name":"eloAsKeyPrefix","tagname":"property","owner":"sol.common.ConfigCache","id":"property-eloAsKeyPrefix","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"cacheDisabled","tagname":"method","owner":"sol.common.ConfigCache","id":"method-cacheDisabled","meta":{"private":true}},{"name":"get","tagname":"method","owner":"sol.common.ConfigCache","id":"method-get","meta":{}},{"name":"getELOasCfg","tagname":"method","owner":"sol.common.ConfigCache","id":"method-getELOasCfg","meta":{}},{"name":"getProtected","tagname":"method","owner":"sol.common.ConfigCache","id":"method-getProtected","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"put","tagname":"method","owner":"sol.common.ConfigCache","id":"method-put","meta":{}},{"name":"putELOasCfg","tagname":"method","owner":"sol.common.ConfigCache","id":"method-putELOasCfg","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ConfigCache","short_doc":"Caching for configuration files. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ConfigCache</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Cache' rel='sol.common.Cache' class='docClass'>sol.common.Cache</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache' target='_blank'>lib_sol.common.Config.js</a></div></pre><div class='doc-contents'><p>Caching for configuration files.</p>\n\n<p>Cache is disabled for administrative users. If an administrative user requests a cached config this class always returns <code>null</code>.</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-cache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-property-cache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-property-cache' class='name expandable'>cache</a> : <a href=\"#!/api/sol.common.Cache\" rel=\"sol.common.Cache\" class=\"docClass\">sol.common.Cache</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>This contains the already loaded configurations</p>\n</div><div class='long'><p>This contains the already loaded configurations</p>\n</div></div></div><div id='property-eloAsKeyPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-property-eloAsKeyPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-property-eloAsKeyPrefix' class='name expandable'>eloAsKeyPrefix</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;ELOASCONFIG#&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-cacheDisabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-method-cacheDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-method-cacheDisabled' class='name expandable'>cacheDisabled</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if caching is disabled. ...</div><div class='long'><p>Checks, if caching is disabled.\nCurrently caching is only disabled for administrative users with interactive login flag.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-method-get' class='name expandable'>get</a>( <span class='pre'>key</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves a configuration from the cache. ...</div><div class='long'><p>Retrieves a configuration from the cache.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getELOasCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-method-getELOasCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-method-getELOasCfg' class='name expandable'>getELOasCfg</a>( <span class='pre'>solution</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves an ELOas configuration from the cache. ...</div><div class='long'><p>Retrieves an ELOas configuration from the cache.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>solution</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getProtected' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-method-getProtected' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-method-getProtected' class='name expandable'>getProtected</a>( <span class='pre'>key</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves a configuration from the cache. ...</div><div class='long'><p>Retrieves a configuration from the cache. Configs with protected flag will only delivered from cache for service users.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-put' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-method-put' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-method-put' class='name expandable'>put</a>( <span class='pre'>key, cfg</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Puts a configuration into the cache. ...</div><div class='long'><p>Puts a configuration into the cache.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-putELOasCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigCache'>sol.common.ConfigCache</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigCache-method-putELOasCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigCache-method-putELOasCfg' class='name expandable'>putELOasCfg</a>( <span class='pre'>solution, cfg</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Puts an ELOas configuration into the cache. ...</div><div class='long'><p>Puts an ELOas configuration into the cache.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>solution</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"singleton":true}});